#import( class , HashArray )
#import( class , CDB_Ram )
#import( class , CS_ParseMail )
#import( class , CS_Bayes )
#import( class , CS_BayesWord )
#import( class , CS_FileSystem )


#include "lib.cs"

CS_ADMIN_SCRIPT this = new CS_ADMIN_SCRIPT($_this);

int Main(CAdminRequest pRequest, CAdminResponse pResponse)
{

   if (pRequest->GetRecordCount() == 1)
   {
      HashArray fields =  pRequest->GetRow();
      CS_Bayes bayes = this->GetDBBayes();

    if (bayes == NULL)
        return CONTINUE_SCRIPT;

     string key  = fields->GetS("c1");
     string tipo = fields->GetS("c2");
	
     string source;
     if (tipo == "ham")
	source = "/quarantine/ham/";
     if (tipo == "spam")
	source = "/quarantine/spam/";
     if (tipo == "neutral")
	source = "/quarantine/neutral/";
     if (tipo == "learn")
	source = "/quarantine/learn/";

    if (source == "")
        return CONTINUE_SCRIPT;

    CS_FileSystem sys = new CS_FileSystem();

    if (sys->FileExists(sys->AppPath() + source + key + ".eml") == true)
    {
   
      CS_ParseMail email = new CS_ParseMail();
   
      if (email->LoadFromFile(sys->AppPath() + source + key + ".eml") == true)
      {
	pResponse->Addnew();
        pResponse->SetFieldAt(1,email->GetRawEmail());
      }

      delete sys;
      delete email;
      pResponse->Send(pRequest->GetCmd(),CR_ACK);
    }
   }
   
return CONTINUE_SCRIPT;

}